function pLaw = fitPowerLaws(pdfs, opts)
	pLaw = struct();

	for n = 1:numel(pdfs)
		id = pdfs(n).Astar >= opts.pLawInterval(1) & pdfs(n).Astar < opts.pLawInterval(2);

		[pLaw(n).aLwAcc, pLaw(n).bLwAcc] = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).LwAcc(id));
		[pLaw(n).aLdAcc, pLaw(n).bLdAcc] = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).LdAcc(id));
		[pLaw(n).aLtAcc, pLaw(n).bLtAcc] = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).LtAcc(id));
		[pLaw(n).aLw,    pLaw(n).bLw]    = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).Lw(id));
		[pLaw(n).aLd,    pLaw(n).bLd]    = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).Ld(id));
		[pLaw(n).aLt,    pLaw(n).bLt]    = fitPowerLaw(pdfs(n).Astar(id), pdfs(n).Lt(id));
	end
end